//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------



#include "keyboard.h"

//Función proporcionada por ronaldo para redefinición de teclas
cpct_keyID esperaUnaTecla() {
    // Recorreremos el vector de teclas desde el final hacia el principio,
    // para poder hacer que el bucle acabe en 0 (así el compilador podrá optimizarlo)
    u8 i = 10, *keys = cpct_keyboardStatusBuffer + 9;
    u16 keypressed;
    
    // Esperamos hasta que se pulse una tecla
    while ( ! cpct_isAnyKeyPressed() );
    
    // Detectamos cuál tecla ha sido pulsada
    do {
        // Si en este grupo de 8 teclas hay una pulsada, alguno de los bits estará a 0
        // En caso contrario, todos estarán a 1, y un XOR con 0xFF dará 0 (FALSE) como resultado
        keypressed = *keys ^ 0xFF;
        if (keypressed)
            return (keypressed << 8) + (i - 1);  // Formato cpct_keyID: 8 primeros bits = máscara de tecla, 8 siguientes fila del teclado (0-9)
        keys--;
    } while(--i);
    
}

void waitKeyUp(cpct_keyID key) {
    
    while(cpct_isKeyPressed(key));

}

u32 wait4Key(cpct_keyID key) {

	u32 c;

	while(!cpct_isKeyPressed(key));
    do{
    	c++;
    }
    while(cpct_isKeyPressed(key));

    return c;
}

cpct_keyID redefineKey(u8 *text){
    
    cpct_keyID key;
    
    u8* pvideo = cpctm_screenPtr(g_scrbuffers[1], 39 - 10 * FONT_W, 90);
    cpct_drawSolidBox(pvideo, cpct_px2byteM0(15, 15), 15 * FONT_W, FONT_H);
    
    drawText(text, 90);
    
    key = esperaUnaTecla();
    waitKeyUp(key);
    
    return key;
    
}

void checkCommonKeys(){


    if(cpct_isKeyPressed(keys.abort)){

        gameOver = TRUE;

    }

    if(cpct_isKeyPressed(keys.pause)){

        pause = !pause;

        waitKeyUp(keys.pause);
    }

}

void checkKeyboardGame(Entity *hero, Entity *target) {

    u8 static fireCycles;
    u8 fire = cpct_isKeyPressed(keys.fire);

    checkCommonKeys();

    hero->pstate = hero->state;
    hero->pxPos = hero->xPos;

    target->pxPos = target->xPos;
    target->pyPos = target->yPos;


    if(!pause && hero->state < HERO_STATE_HIT){

    	hero->state = HERO_STATE_ON_FLOOR;

    	if(fire){

    		if(fireCycles >= 4){

    			cpct_akp_SFXPlay(1, 15, 36, 0, 0, AY_CHANNEL_A);
				fireCycles = 0;

			}

    		hero->state = HERO_STATE_FIRING;
    	}

		if(cpct_isKeyPressed(keys.left)){


			if(!fire){

				hero->xPos-=3;
				if(hero->xPos < MIN_X) hero->xPos = MIN_X;

				hero->state = HERO_STATE_GOING_LEFT;

				target->xPos -= 5;

			}
			else target->xPos -= 4;

			if(target->xPos < MIN_X) target->xPos = MIN_X;

			if(!facingLeft){

				cpct_hflipSpriteM0 (HERO_W, HERO_H, G_danielRun1);
				cpct_hflipSpriteM0 (HERO_W, HERO_H, G_danielRun2);

			    facingLeft = TRUE;

			}

		}

		else if(cpct_isKeyPressed(keys.right)){


			if(!fire){

				hero->xPos+=3;
				if(hero->xPos > MAX_X - HERO_W) hero->xPos = MAX_X - HERO_W + 1;

				hero->state = HERO_STATE_GOING_RIGHT;

				target->xPos += 5;
			}

			else target->xPos += 4;

			if(target->xPos > MAX_X - TARGET_W) target->xPos = MAX_X - TARGET_W + 1;

			if(facingLeft){

				cpct_hflipSpriteM0 (HERO_W, HERO_H, G_danielRun1);
				cpct_hflipSpriteM0 (HERO_W, HERO_H, G_danielRun2);

				facingLeft = FALSE;

			}

		}

		if(cpct_isKeyPressed(keys.down)){

			target->yPos+=8;

			if(target->yPos > MAX_Y - TARGET_H - 1) target->yPos = MAX_Y - TARGET_H - 1;


		}

		else if(cpct_isKeyPressed(keys.up)){

			target->yPos-=8;

			if(target->yPos > MAX_Y) target->yPos = MIN_Y;


		}

		fireCycles++;

        if(hero->state != hero->pstate) hero->cycles = 0;

    }

}

void checkKeyboardMenu() {

	static u32 seed;
    u8 *pvideo;
    static u8 selectedOption;

    if(cpct_isKeyPressed(Key_1)){

        selectedOption = 1;

        waitKeyUp(Key_1);

        keys.up    = redefineKey("UP");
        keys.down  = redefineKey("DOWN");
        keys.left  = redefineKey("LEFT");
        keys.right = redefineKey("RIGHT");
        keys.fire  = redefineKey("FIRE");
        keys.pause = redefineKey("PAUSE");
        keys.abort = redefineKey("END");

        pvideo = cpct_getScreenPtr(g_scrbuffers[1], 37 - 10 * FONT_W, 90);
        cpct_drawSolidBox(pvideo, cpct_px2byteM0(15, 15), 15 * FONT_W, FONT_H);

    }
    else if(cpct_isKeyPressed(Key_2)){

        selectedOption = 2;

        keys.up    = Joy0_Up;
        keys.down  = Joy0_Down;
        keys.left  = Joy0_Left;
        keys.right = Joy0_Right;
        keys.fire  = Joy0_Fire1;

    }
	else if(cpct_isKeyPressed(Key_3)){

			seed = wait4Key(Key_3);
			if(!seed) seed++;
			cpct_srand(seed);

			game();
			decompress((u8*)EXO_outlaws, (u8*)EXOBUFFER_ADDRESS);
			loopMusic = TRUE;

			cpct_akp_musicInit(G_outlaws);
			drawMenu();
	}


}
